#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Rain SDFMod01.fsh   by   satyam  
//https://www.shadertoy.com/view/lflBW8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define STEPS 100
#define MAXDIST 100.
#define MINDIST 0.001
#define SURF_DIST 0.001

float smin(float a, float b, float k)
{
    float h = max(k - abs(a-b), 0.0)/k;
    return min(a,b) - h*h*h*k*(1.0/6.0);
}

mat2 Rotation(float a)
{
//Rotation as per matricies
    float s = sin(a);
    float c = cos(a);
    return mat2(c,-s,s,c);
}

float Capsule(vec3 p, vec3 c1, vec3 c2, float r)
{
    float t = dot(p-c1, c2-c1)/dot(c2-c1,c2-c1);
    t = clamp(t,0.0,1.0);
    vec3 pointOnLineSegment = c1 + t * (c2-c1);
    float distanceToCapsule = length(p-pointOnLineSegment) - r;
    return distanceToCapsule;
}

float Cylinder(vec3 p, vec3 c1, vec3 c2, float r)
{
    float t = dot(p-c1, c2-c1)/dot(c2-c1,c2-c1);
    vec3 pointOnLineSegment = c1 + t * (c2-c1);
    float x = length(p-pointOnLineSegment) - r;
    float y = (abs(t-0.5)-0.5) * length(c2-c1);
    float d = length(max(vec2(x,y),0.));
    float interiorDistance = min(max(x,y),0.);
    return d + interiorDistance;
}

float Torus(vec3 p, float r1, float r2)
{
    float l = length(p.xz) - r1;
    float h = p.y;
    return length(vec2(l,h)) - r2;
}

float Box(vec3 p, float height, float width, float depth)
{
    float pointOfContactOn_X = abs(p.x) - width/2.;
    float pointOfContactOn_Y = abs(p.y) - height/2.;
    float pointOfContactOn_Z = abs(p.z) - depth/2.;
    
    return length(vec3(max(pointOfContactOn_X,0.),max(pointOfContactOn_Y,0.),max(pointOfContactOn_Z,0.)));
}

float Sphere(vec3 p, vec3 center, float radius)
{
    return length(p- center) - radius;
}

float GetDist(vec3 p)
{
    float distanceToPlane = p.y - iTime;
    
    vec3 positionOfBox = p - vec3(0., abs(sin(iTime)) + 1., 2.);
    positionOfBox.xy =  Rotation(sin(iTime)) * positionOfBox.xy; //Rotating the point
    float distanceToBox = Box(positionOfBox, 1.,1.,1.);
    
    vec3 sphere;
    sphere = p-vec3(0.,2.,3.); //Translation
    sphere = sphere * vec3(1.,1.,1.); //Scaling
    float distSphere = length(sphere) - 2.;
    
    vec3 sphere2;
    sphere2 = p-vec3(3.,5.,3.); //Translation
    sphere2 = sphere * vec3(2.,.5,1.); //Scaling
    float distSphere2 = length(sphere2) - 2.;
    
    // Space Repitition of Sphere
    vec3 modP = mod(p, 2.);
    float distanceToSphere = Sphere(modP, vec3(1.,1.,1.), .15);    
    float distanceToSphere2 = Sphere(modP, vec3(1.,1.,1.), .5);
    
    //Scaled Sphere
    vec3 scaledSphere;
    scaledSphere = modP - vec3(1.,1.5,1.);
    scaledSphere = scaledSphere * vec3(4.5,1.,4.5);
    float distToScaleSphere = length(scaledSphere) - .25;
    
    vec3 q = fract(p) - 0.5;
    q = abs(q);
    float l = length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0);    
    
    float shape;
    float testShape; //This makes the water droplets
    testShape = smin(distanceToPlane, distToScaleSphere/5., .25);
    testShape = smin(testShape, distanceToSphere, 1.);
    
    shape = min(distanceToSphere, distanceToPlane);
    shape = max(shape, -distanceToSphere2);
    shape = min(shape, distanceToSphere);
    shape = smin(shape, distanceToSphere, .75);
    shape = smin(shape, distToScaleSphere/5., 1.);
    
    return testShape;
    //return smin(distanceToSphere,smin(distanceToCapsule, distanceToPlane, 1.),2.);
}

vec3 GetNormal(vec3 p)
{
    vec2 smallMarginToShift = vec2(0.01, 0);
    float distanceToPoint = GetDist(p);
    
    vec3 normal = vec3(
        distanceToPoint - GetDist(p-smallMarginToShift.xyy),
        distanceToPoint - GetDist(p-smallMarginToShift.yxy),
        distanceToPoint - GetDist(p-smallMarginToShift.yyx)
    );
    
    return normalize(normal);
}

float RayMarch(vec3 rayOrigin, vec3 rayDirection)
{
    float distanceOrigin = 0.0;
    for(int i = 0; i < STEPS ; i++)
    {
        vec3 pointOfFirstContact = rayOrigin + distanceOrigin * rayDirection;
        float distanceFromCircelCenterToContact = GetDist(pointOfFirstContact);
        distanceOrigin += distanceFromCircelCenterToContact;
        
        if(distanceOrigin > MAXDIST || distanceFromCircelCenterToContact < MINDIST) break;
    }
    
    return distanceOrigin;
}

float GetLight(vec3 p)
{
    vec3 lightPosition = vec3(0., 3. + iTime,-3. );
    //vec3 lightPosition = vec3(0.,3.,-3.);
    //lightPosition.xz += vec2(sin(iTime), cos(iTime)) * 2.0;
    vec3 lightVector = normalize(lightPosition - p);
    vec3 normal = GetNormal(p);
    float diffuseValue = clamp(dot(lightVector,normal) * .5 + .5, 0.0, 1.0) ; //mul by .5 and add by .5 makes the image lighter
    
    //Shadow
    float shadowToLight = RayMarch(p + normal * SURF_DIST,lightVector);
    if(p.y<.01 && shadowToLight < length(lightPosition - p)) diffuseValue = diffuseValue * 0.5;
    
    return diffuseValue;
}

vec3 palette( in float t)
{
    vec3 a = vec3(0.206 ,0.912 ,0.519);
    vec3 b = vec3(0.814 ,0.296 ,0.693);
    vec3 c = vec3(0.389 ,0.714 ,0.805);
    vec3 d = vec3(5.877 ,2.424 ,3.245);

    return a + b*cos( 6.28318*(c*t+d) );
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = vec2(fragCoord.x/iResolution.x - 0.5, fragCoord.y/iResolution.y - 0.5);
    uv.x = uv.x * iResolution.x/iResolution.y; // To remove stretchiness from the scene because of uneven aspect ratio
    
    //vec2 uv = (fragCoord * 2.0 - iResolution.xy)/iResolution.y; //Shortform of the above thing

    vec3 rO = vec3(0.0, 1.0 + iTime, -5.0) ;//RayOrigin
    
    //vec2 m = iMouse.xy/iResolution.xy;
    
    //rO.yz *= Rotation(-m.y+.4);
    //rO.xz *= Rotation(.2-m.x*6.2831);
    
    
    vec3 rD = normalize(vec3(uv.x,uv.y ,1));//RayDirection
    
    float col = RayMarch(rO, rD);
    vec3 col3 = vec3(0);
    
    if(col < MAXDIST){
        vec3 pointForLight = rO + rD * col;
        float diffuseLight = GetLight(pointForLight);
        col3 = vec3(diffuseLight);
    }
    
    
    //fragColor = vec4(diffuseLight,diffuseLight,diffuseLight,1.);
    
    //col = col/12.;
    //fragColor = vec4(col, col, col,1.0);
    
    vec3 color = palette(col + iTime);
    
    col3 = pow(col3, vec3(.4545));	// gamma correction

    fragColor = vec4(col3 * color  , 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

